<?php
/**
 * Settings Page Template.
 *
 * @package WP_WebP_Optimizer
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<?php
// Load required classes for stats
require_once SMALL_IMAGE_PLUGIN_DIR . 'includes/class-stats.php';
require_once SMALL_IMAGE_PLUGIN_DIR . 'includes/class-bulk-processor.php';

$stats = WP_WebP_Optimizer_Stats::get_stats();
$processor = new WP_WebP_Optimizer_Bulk_Processor();
$unconverted_count = count( $processor->get_unconverted_images() );
$support = WP_WebP_Optimizer_Converter::check_webp_support();
?>

<div class="wrap webp-bulk-converter-wrap">
	<h1><?php esc_html_e( 'Dashboard', 'small-image' ); ?></h1>

	<div class="webp-bulk-content">
		<!-- Statistics Overview -->
		<div class="webp-stats-cards">
			<div class="stat-card">
				<div class="stat-icon">
					<span class="dashicons dashicons-images-alt2"></span>
				</div>
				<div class="stat-details">
					<div class="stat-value"><?php echo esc_html( number_format( $stats['total_images'] ) ); ?></div>
					<div class="stat-label"><?php esc_html_e( 'Total Images', 'Mak8it.com' ); ?></div>
				</div>
			</div>

			<div class="stat-card success">
				<div class="stat-icon">
					<span class="dashicons dashicons-yes-alt"></span>
				</div>
				<div class="stat-details">
					<div class="stat-value"><?php echo esc_html( number_format( $stats['converted_images'] ) ); ?></div>
					<div class="stat-label"><?php esc_html_e( 'Converted', 'Mak8it.com' ); ?></div>
				</div>
			</div>

			<div class="stat-card warning">
				<div class="stat-icon">
					<span class="dashicons dashicons-clock"></span>
				</div>
				<div class="stat-details">
					<div class="stat-value"><?php echo esc_html( number_format( $unconverted_count ) ); ?></div>
					<div class="stat-label"><?php esc_html_e( 'Pending', 'Mak8it.com' ); ?></div>
				</div>
			</div>

			<div class="stat-card info">
			<div class="stat-icon">
				<span class="dashicons dashicons-database"></span>
			</div>
			<div class="stat-details">
				<div class="stat-value"><?php echo esc_html( WP_WebP_Optimizer_Stats::get_formatted_space_saved() ); ?></div>
				<div class="stat-label"><?php esc_html_e( 'Space Saved', 'small-image' ); ?></div>
			</div>
		</div>
		</div>

		<!-- Main Content -->
		<div class="webp-converter-main">
			<div class="webp-converter-card">
				<h2><?php esc_html_e( 'Plugin Settings', 'Mak8it.com' ); ?></h2>
				
				<form method="post" action="options.php">
					<?php
					// Output security fields
					settings_fields( 'wp_webp_optimizer_settings_group' );
					
					// Output settings sections
					do_settings_sections( 'small-image' );
					
					
				// Custom submit button without WordPress classes
				?>
				<p class="sl-submit-wrapper">
					<button type="submit" name="submit" class="button-primary">
						<?php esc_html_e( 'Save Settings', 'small-image' ); ?>
					</button>
				</p>
				<?php
				?>
				</form>
			</div>

			<!-- Sidebar -->
			<div class="webp-converter-sidebar">
				<div class="sidebar-card">
					<h3><?php esc_html_e( 'Quick Actions', 'Mak8it.com' ); ?></h3>
					<p style="margin-bottom: 15px;">
						<a href="<?php echo esc_url( admin_url( 'admin.php?page=small-image-bulk' ) ); ?>" class="button button-primary" style="width: 100%; text-align: center; margin-bottom: 10px;">
							<span class="dashicons dashicons-images-alt2" style="vertical-align: middle;"></span>
							<?php esc_html_e( 'Bulk Convert Images', 'Mak8it.com' ); ?>
						</a>
					</p>
				</div>

				<div class="sidebar-card">
					<h3><?php esc_html_e( 'About Small Image', 'Mak8it.com' ); ?></h3>
					<p><?php esc_html_e( 'Small Image is a free plugin that converts your images to WebP format, which is a modern image format that provides superior compression for images on the web. WebP images are typically 25-35% smaller than JPEG and PNG images at equivalent quality.', 'Mak8it.com' ); ?></p>
				</div>

				<div class="sidebar-card">
					<h3><?php esc_html_e( 'Benefits', 'Mak8it.com' ); ?></h3>
					<ul class="benefits-list">
						<li>
							<span class="dashicons dashicons-yes-alt" style="color: #00a32a;"></span>
							<?php esc_html_e( 'Faster page load times', 'Mak8it.com' ); ?>
						</li>
						<li>
							<span class="dashicons dashicons-yes-alt" style="color: #00a32a;"></span>
							<?php esc_html_e( 'Reduced bandwidth usage', 'Mak8it.com' ); ?>
						</li>
						<li>
							<span class="dashicons dashicons-yes-alt" style="color: #00a32a;"></span>
							<?php esc_html_e( 'Better SEO rankings', 'Mak8it.com' ); ?>
						</li>
						<li>
							<span class="dashicons dashicons-yes-alt" style="color: #00a32a;"></span>
							<?php esc_html_e( 'Improved user experience', 'Mak8it.com' ); ?>
						</li>
					</ul>
				</div>

				<div class="sidebar-card info-card">
				<h3><?php esc_html_e( 'Report a Bug', 'small-image' ); ?></h3>
				<p><?php esc_html_e( 'Found an issue? Let us know and we\'ll fix it as soon as possible.', 'small-image' ); ?></p>
				<p>
					<a href="mailto:info@mak8it.com?subject=Report%20Bug%20In%20Small%20Image" class="button button-secondary" style="width: 100%; text-align: center;">
						<span class="dashicons dashicons-email" style="vertical-align: middle;"></span>
						<?php esc_html_e( 'Report a Bug', 'small-image' ); ?>
					</a>
				</p>
			</div>
			</div>
		</div>
	</div>
</div>
